﻿using FAQ.Repository.Contracts;
using Microsoft.AspNetCore.Mvc;

namespace FAQ.Controllers.Api
{
    public class ApiController : Controller
    {
        private IQuestionRepository questionRepository;


        /// <summary>
        /// Initialise une nouvelle instance du contrôleur avec le dépôt spécifié.
        /// </summary>
        /// <param name="questionRepository">Le dépôt des versions.</param>
        public ApiController(IQuestionRepository questionRepository) { 
        
        this.questionRepository = questionRepository;

        }

        /// <summary>
        /// Trouve et renvoie la liste des questions.
        /// </summary>
        [Route("api/questions")]
        public IActionResult Questions() {
            return this.Ok(this.questionRepository.FindAll().Select(q => new { q.Titre, q.Reponse }).ToList());
         }


    }
}
